#region AuthorHeader
//
//	EvoSystem version 2.1, by Xanthos
//
//
#endregion AuthorHeader
using System;
using Server;
using Server.Items;
// using Xanthos.Interfaces;
// using Xanthos.Evo;

namespace Server.Mobiles
{
	//[CorpseName( "a guardian mercenary corpse" )]
	public class GuardianMercenary : BaseCreature
	{
		private double kReflectDamagePercent = 20;
		
		public override WeaponAbility GetWeaponAbility()
		{
			switch ( Utility.Random( 3 ) )
			{
				default:
				case 0: return WeaponAbility.DoubleStrike;
				case 1: return WeaponAbility.WhirlwindAttack;
				case 2: return WeaponAbility.CrushingBlow;
			}
		}
		
		public GuardianMercenary( Serial serial ) : base( serial )
		{
		}
		
		[Constructable]
		public GuardianMercenary() : base( AIType.AI_Melee, FightMode.Closest, 10, 1, 0.2, 0.4 )
		{
         Name = "Guardian Mercenary";
			Hue = Utility.RandomSkinHue(); 
			Body = 0x190; 
         Item hair = new Item( Utility.RandomList( 0x203B, 0x2049, 0x2048, 0x204A ) ); 
         hair.Hue = Utility.RandomNeutralHue(); 
         hair.Layer = Layer.Hair; 
         hair.Movable = false; 
         AddItem( hair );
         
			PassiveSpeed /= Paragon.SpeedBuff;
			ActiveSpeed /= Paragon.SpeedBuff;

         if( Utility.RandomBool() )
         {
            Item beard = new Item( Utility.RandomList( 0x203E, 0x203F, 0x2040, 0x2041, 0x204B, 0x204C, 0x204D ) );
            beard.Hue = hair.Hue;
            beard.Layer = Layer.FacialHair;
            beard.Movable = false;
            AddItem( beard );
         }
         
			SetDamageType( ResistanceType.Physical, 80 );
			SetDamageType( ResistanceType.Cold, 20 );

			SetResistance( ResistanceType.Physical, 40 );
			SetResistance( ResistanceType.Fire, 30 );
			SetResistance( ResistanceType.Cold, 30 );
			SetResistance( ResistanceType.Poison, 30 );
			SetResistance( ResistanceType.Energy, 30 );
			
			SetStr( 390, 460 );
			SetDex( 61, 70 );
			SetInt( 91, 100 );

			SetHits( 4000 );
			SetStam( 503, 650 );
			SetMana( 593, 650 );
			SetDamage( 28, 35 );
			
			Fame = 22500;
			Karma = -22500;

			VirtualArmor = 60;

			SetSkill( SkillName.Chivalry, 115.0, 120.5 );
			SetSkill( SkillName.MagicResist, 65.0, 97.5 );
			SetSkill( SkillName.Swords, 115.0, 120.5 );
			SetSkill( SkillName.Tactics, 115.0, 120.5 );
			SetSkill( SkillName.Wrestling, 115.0, 125.5 );
			SetSkill( SkillName.Anatomy, 115.0, 127.5 );
			SetSkill( SkillName.Parry, 115.0, 127.5 );
			
			this.Tamable = false;	// Not appropriate as a pet
			Title = "";

			FightMode = (FightMode)Utility.RandomMinMax( (int)FightMode.Aggressor, (int)FightMode.Evil );

			// Now dress it up
			AddItem( new LeatherArms() );
			AddItem( new LeatherChest() );
			AddItem( new LeatherLegs() );
			AddItem( new Boots() );
			SpiritOfTheTotem totem = new SpiritOfTheTotem(); totem.LootType = .05 > Utility.RandomDouble() ? LootType.Regular : LootType.Blessed;
			BladeOfInsanity blade = new BladeOfInsanity(); blade.LootType = LootType.Blessed; blade.Movable = false; blade.MaxHitPoints = -1;
			GauntletsOfNobility gloves = new GauntletsOfNobility(); gloves.LootType = .05 > Utility.RandomDouble() ? LootType.Regular : LootType.Blessed;
			JackalsCollar collar = new JackalsCollar(); collar.LootType = .05 > Utility.RandomDouble() ? LootType.Regular : LootType.Blessed;
			AddItem( totem );
			AddItem( blade );
			AddItem( gloves );
			AddItem( collar );
			PackItem( new Bandage( Utility.RandomMinMax( 500, 1000 ) ) );
			new Nightmare().Rider = this;
			
			if ( Utility.RandomDouble() < 0.20 )				
				PackItem( new Xanthos.Evo.MercenaryDeed() );
		}

		public override bool ShowFameTitle{ get{ return false; } }
      public override bool AlwaysMurderer{ get{ return true; } }
		public override bool BardImmune{ get{ return true; } }
		public override bool CanRummageCorpses{ get{ return true; } }
		
		public override void GenerateLoot()
		{
			AddLoot( LootPack.AosUltraRich, 2 );
			AddLoot( LootPack.AosFilthyRich, 3 );
		}
		
		public override void OnDamage( int amount, Mobile from, bool willKill, int typ )
		{
			base.OnDamage( amount, from, willKill, typ );

			if ( kReflectDamagePercent > 0 && null != from && !(from.Deleted))
				from.Damage( (int)(Math.Round( amount / kReflectDamagePercent )), this );
		}

		public override void Serialize(GenericWriter writer)
		{
			base.Serialize(writer);

			writer.Write( (int)0 );			
		}

		public override void Deserialize(GenericReader reader)
		{
			base.Deserialize(reader);

			int version = reader.ReadInt();
		}
	}
}